namespace Ap8_Alexandre_Saulnier
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void btn_calc_binaire_Click(object sender, EventArgs e)
        {
            //  vrifier la magnifique IP
            string[] parts = tb_ip.Text.Split('.');
            if (parts.Length != 4)
            {
                MessageBox.Show("Format IP invalide");
                
            }

            for (int i = 0; i < 4; i++)
            {
                if (!byte.TryParse(parts[i], out Global.ip[i]))
                {
                    MessageBox.Show("Chaque octet doit tre entre 0 et 255");
                    
                }
            }

            // vrifier le CIDR
            if (!int.TryParse(tb_cidr.Text, out Global.cidr) || Global.cidr < 0 || Global.cidr > 32)
            {
                MessageBox.Show("CIDR invalide (0..32)");
                
            }

            // convertir en binaire
            Global.ipBinaire = string.Join(".", Global.ip.Select(o => Convert.ToString(o, 2).PadLeft(8, '0')));

            // afficher le rsultat 
            lb_ip_en_binaire.Text = Global.ipBinaire;

            // dverrouiller bouton
            btn_suivant.Enabled = true;
        }

        private void btn_quitter_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void btn_suivant_Click(object sender, EventArgs e)
        {
            Etape2 plop = new Etape2();
            plop.Show();
            
        }
    }
}
